-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    if not self.loaded then
      self.captured = false
    end
    self.p0 = Citadels.GetPlayer(0)
    self.p3 = Citadels.GetPlayer(3)
    self.pos = self:GetPosition()
    
    self.supplyTown:LinkToTarget("suTownBuilding")  
    self.supplyTown:LinkToTarget("supportArmy")
    self.supplyTown:LinkToTarget("deactivate")
    self.supplyTown:LinkToTarget("activateAttackLt")
    self.supplyTown:LinkToTarget("activateAttackSt")
    self.supplyTown:LinkToTarget("victory")
    self.supplyTown:LinkToTarget("p3deact")
  end
  
  if self.captured then    
    self.supplyTown:TriggerAllTargets()
    DeactivatePlayer3()
    self.p0:WinQuest('D2G_GOAL_1')
    
    MarkMainGoal(self)
    self.captured = false 
  end
end

function MarkMainGoal(self)
  g3PosX = Game:GetEntity("smallTown"):GetPosition().x
  g3PosY = Game:GetEntity("smallTown"):GetPosition().y
  
  self.p0:AddQuest('D2G_GOAL_2','main')
  self.p0:AddQuest('D2G_GOAL_3','main')
  self.p0:SetQuestPosition('D2G_GOAL_3', g3PosX, g3PosY)
end

function DeactivatePlayer3()
  p3 = Game:GetEntity("player3")
  Debug:Log("P3 townhall -> " .. tostring(p3:GetProperty("startWithTownhall")))
  p3:SetProperty("startWithTownhall", false)
  Debug:Log("P3 townhall -> " .. tostring(p3:GetProperty("startWithTownhall")))
end
  
function OnTrigger(self, source, target)    
  if target == "defendersKilled" then
    self.captured = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.captured = ar:Read()
   elseif (ar:IsSaving()) then
	  ar:Write(self.captured)
   end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("defendersKilled")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("supplyTown")
end

